# DragonInjector Project

Welcome! This project aims to build a Nintendo Switch payload injector in the form factor of a standard game cartridge, so that it can be stored inside the console for easy transportation and use. DragonInjector will include an RCM jig in the cap and is powered by a CR1612 battery good for over 3000 injections!

The source files for DragonInjector will be posted here once the project is complete. This will include:

- The Eagle project file, schematic and board file.
- The 3D models in .STEP and .STL format.
- A bitmap version of the schematic.
- Ready-to-go gerbers.
- Full BOM.
- Firmware files and source.

## FAQ

### What is DragonInjector?
DragonInjector is a Switch payload injector in the form factor of a game cartridge, so it can easily be stored inside your Switch. There's even an RCM jig built into the cap!

### How is it powered?
DragonInjector is powered by a CR1612 watch battery. To avoid shipping restrictions, the DragonInjector does not ship with a CR1612 in the package.

### How many injections can I get on a full charge?
Over 3000 injections! Testing showed between 3400 and 3500 injections on average per CR1612.

### Does this click in my game card slot like a normal game card?
Yes! Mechanically, it behaves exactly the same way.

### Can this charge from the game card slot?
Nope. Since the DragonInjector gets over 3000 injections on a single CR1612, a rechargeable model wouldn't provide enough benefit to justify the much higher expense required to develop and manufacture it, and would even have some drawbacks.

### Can this inject a payload through the game card slot?
No, unfortunately this is impossible without significant modifications to the Switch. Payloads are injected via the Type C slot as is typical for all injectors.

### What about those game card pins then? What do they do?
They're there for aesthetic purposes and to protect the pins in the game cartridge slot from damage and wear.

### How do I put payloads on the DragonInjector? Will this support more than one payload at a time and can you switch between them?
Yes! Payloads are stored on your MicroSD card. Normally it'll just boot whatever payload it finds first in /DragonInjector/, but for advanced users there will also be the option to enable additional payload slots (up to 8) and switch between them with the button on the DragonInjector. In this case, it'll boot the first payload it finds in /DragonInjector/Payload_1/ through /DragonInjector/Payload_8/. The LEDs will let you know which slot you have selected.

### I'm an advanced user, can I write my own firmware? What about updates?
Of course! Feel free to fork the GitHub and make whatever changes you wish. If you make something cool, let me know! In the event the firmware on the DI requires updating or you want to write your own, you can just plug it into a computer and it will show up as mass storage device DRAGONBOOT, and you can drag the new firmware to it and it will update itself and reboot.

### Is there a place we can follow and chat about the project or ask questions that aren't fit for this development thread?
Yes! There's a Discord server where I post progress, renders, photos, and other things quite often. Link: https://discord.gg/7yEupZs

### When can I get one?
The project is still in development and should be ready for sale in a few weeks.

### How much will it cost?
$25 USD, excluding shipping.

### Where can I buy it?
When it's ready, you'll be able to buy the DragonInjector through Tindie. You can visit the store page by clicking the button in my signature.

### Shipping to my country is expensive. Will you consider combined shipping?
Of course! Visit the Discord server and find your country under the "Combined Shipping Help" category on the left to coordinate with other buyers in your area. If your country doesn't exist, mention me in the #dragoninjector channel and let me know you'd like it added.

### What colors will it be offered in?
The first batch of units will be available in translucent green and black. If there is enough demand for other colors they will become an option in the future.

This project is licensed under the Creative Commons Attribution-ShareAlike licence. (CC BY-SA 4.0)

You can find out more by reading the LICENCE.md file included with this document.
