/*
 * Copyright (c) 2013, NVIDIA CORPORATION.  All rights reserved.
 * Copyright 2014 Google Inc.
 * Copyright (c) 2018 naehrwert
 * Copyright (c) 2018 CTCaer
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 */

#include "soc/t210.h"
#include "soc/pmc_lp0_t210.h"
#include "mem/sdram_lp0_param_t210.h"

/*
 * This function reads SDRAM parameters from the common BCT format and
 * writes the minimal set into PMC scratch registers
 * (for exploiting the bootrom arbitrary writes)
 */
void sdram_lp0_save_params(const void *params)
{
	struct sdram_params *sdram = (struct sdram_params *)params;
	struct tegra_pmc_regs *pmc = (struct tegra_pmc_regs *)PMC_BASE;

#define pack(src, src_bits, dst, dst_bits) { \
	u32 mask = 0xffffffff >> (31 - ((1 ? src_bits) - (0 ? src_bits))); \
	dst &= ~(mask << (0 ? dst_bits)); \
	dst |= ((src >> (0 ? src_bits)) & mask) << (0 ? dst_bits); \
}

#define s(param, src_bits, pmcreg, dst_bits) \
	pack(sdram->param, src_bits, pmc->pmcreg, dst_bits)

#define c(value, pmcreg, dst_bits) \
	pack(value, (1 ? dst_bits) - (0 ? dst_bits) : 0, pmc->pmcreg, dst_bits)

/* 32 bits version of s macro */
#define s32(param, pmcreg) pmc->pmcreg = sdram->param

/* 32 bits version c macro */
#define c32(value, pmcreg) pmc->pmcreg = value

	// Patch SDRAM parameters.
	u32 t0 = sdram->EmcSwizzleRank0Byte0 << 5 >> 29 > sdram->EmcSwizzleRank0Byte0 << 1 >> 29;
	u32 t1 = (t0 & 0xFFFFFFEF) | ((sdram->EmcSwizzleRank1Byte0 << 5 >> 29 > sdram->EmcSwizzleRank1Byte0 << 1 >> 29) << 4);
	u32 t2 = (t1 & 0xFFFFFFFD) | ((sdram->EmcSwizzleRank0Byte1 << 5 >> 29 > sdram->EmcSwizzleRank0Byte1 << 1 >> 29) << 1);
	u32 t3 = (t2 & 0xFFFFFFDF) | ((sdram->EmcSwizzleRank1Byte1 << 5 >> 29 > sdram->EmcSwizzleRank1Byte1 << 1 >> 29) << 5);
	u32 t4 = (t3 & 0xFFFFFFFB) | ((sdram->EmcSwizzleRank0Byte2 << 5 >> 29 > sdram->EmcSwizzleRank0Byte2 << 1 >> 29) << 2);
	u32 t5 = (t4 & 0xFFFFFFBF) | ((sdram->EmcSwizzleRank1Byte2 << 5 >> 29 > sdram->EmcSwizzleRank1Byte2 << 1 >> 29) << 6);
	u32 t6 = (t5 & 0xFFFFFFF7) | ((sdram->EmcSwizzleRank0Byte3 << 5 >> 29 > sdram->EmcSwizzleRank0Byte3 << 1 >> 29) << 3);
	u32 t7 = (t6 & 0xFFFFFF7F) | ((sdram->EmcSwizzleRank1Byte3 << 5 >> 29 > sdram->EmcSwizzleRank1Byte3 << 1 >> 29) << 7);
	sdram->SwizzleRankByteEncode = t7;

  s(ClkRstControllerPllmMisc2Override, 9:8, scratch7, 1:0);
  s(ClkRstControllerPllmMisc2Override, 2:1, scratch7, 3:2);
  s(ClkRstControllerPllmMisc2Override, 13:13, scratch7, 10:10);
  s(ClkRstControllerPllmMisc2Override, 12:12, scratch7, 11:11);
  s(ClkRstControllerPllmMisc2Override, 11:11, scratch7, 12:12);
  s(ClkRstControllerPllmMisc2Override, 10:10, scratch7, 13:13);
  s(ClkRstControllerPllmMisc2Override, 5:5, scratch7, 14:14);
  s(ClkRstControllerPllmMisc2Override, 4:4, scratch7, 15:15);
  s(ClkRstControllerPllmMisc2Override, 3:3, scratch7, 16:16);
  s(ClkRstControllerPllmMisc2Override, 0:0, scratch7, 17:17);
  s(ClkRstControllerPllmMisc2OverrideEnable, 0:0, scratch61, 30:30);
  s(EmcPmacroCommonPadTxCtrl, 3:0, scratch67, 31:28);

	s(EmcClockSource, 7:0, scratch6, 15:8);
	s(EmcClockSourceDll, 7:0, scratch6, 23:16);
	s(EmcClockSource, 31:29, scratch6, 26:24);
	s(EmcClockSourceDll, 31:29, scratch6, 29:27);
	s(EmcClockSourceDll, 11:10, scratch6, 31:30);
	s(EmcClockSource, 15:15, scratch7, 6:6);
	s(EmcClockSource, 26:26, scratch7, 7:7);
	s(EmcClockSource, 20:20, scratch7, 8:8);
	s(EmcClockSource, 19:19, scratch7, 9:9);

	s32(EmcPmacroBrickCtrlRfu1, scratch25);
	s32(EmcPmcScratch1, scratch27);
	s(McEmemArbMisc0, 14:0, scratch61, 14:0);
	s(McEmemArbMisc0, 30:16, scratch61, 29:15);
	s(EmcConfigSampleDelay, 6:0, scratch78, 31:25);
	s(EmcPmacroVttgenCtrl2, 23:0, scratch91, 23:0);

	s(EmcFbioCfg8, 27:16, scratch157, 31:20);
	s(EmcPmacroVttgenCtrl0, 3:0, scratch160, 23:20);
	s(EmcPmacroVttgenCtrl0, 11:8, scratch160, 27:24);
	s(EmcPmacroVttgenCtrl0, 19:16, scratch160, 31:28);
	s(EmcPmacroVttgenCtrl1, 19:0, scratch161, 19:0);

	s(EmcSwizzleRank0Byte0, 2:0, scratch172, 2:0);
	s(EmcSwizzleRank0Byte0, 6:4, scratch172, 5:3);
	s(EmcSwizzleRank0Byte0, 10:8, scratch172, 8:6);
	s(EmcSwizzleRank0Byte0, 14:12, scratch172, 11:9);
	s(EmcSwizzleRank0Byte0, 18:16, scratch172, 14:12);
	s(EmcSwizzleRank0Byte0, 22:20, scratch172, 17:15);

	s(EmcSwizzleRank0Byte1, 2:0, scratch173, 2:0);
	s(EmcSwizzleRank0Byte1, 6:4, scratch173, 5:3);
	s(EmcSwizzleRank0Byte1, 10:8, scratch173, 8:6);
	s(EmcSwizzleRank0Byte1, 14:12, scratch173, 11:9);
	s(EmcSwizzleRank0Byte1, 18:16, scratch173, 14:12);
	s(EmcSwizzleRank0Byte1, 22:20, scratch173, 17:15);

	s(EmcSwizzleRank0Byte2, 2:0, scratch174, 2:0);
	s(EmcSwizzleRank0Byte2, 6:4, scratch174, 5:3);
	s(EmcSwizzleRank0Byte2, 10:8, scratch174, 8:6);
	s(EmcSwizzleRank0Byte2, 14:12, scratch174, 11:9);
	s(EmcSwizzleRank0Byte2, 18:16, scratch174, 14:12);
	s(EmcSwizzleRank0Byte2, 22:20, scratch174, 17:15);

	s(EmcSwizzleRank0Byte3, 2:0, scratch175, 2:0);
	s(EmcSwizzleRank0Byte3, 6:4, scratch175, 5:3);
	s(EmcSwizzleRank0Byte3, 10:8, scratch175, 8:6);
	s(EmcSwizzleRank0Byte3, 14:12, scratch175, 11:9);
	s(EmcSwizzleRank0Byte3, 18:16, scratch175, 14:12);
	s(EmcSwizzleRank0Byte3, 22:20, scratch175, 17:15);

	s(EmcSwizzleRank1Byte0, 2:0, scratch176, 2:0);
	s(EmcSwizzleRank1Byte0, 6:4, scratch176, 5:3);
	s(EmcSwizzleRank1Byte0, 10:8, scratch176, 8:6);
	s(EmcSwizzleRank1Byte0, 14:12, scratch176, 11:9);
	s(EmcSwizzleRank1Byte0, 18:16, scratch176, 14:12);
	s(EmcSwizzleRank1Byte0, 22:20, scratch176, 17:15);

	s(EmcSwizzleRank1Byte1, 2:0, scratch177, 2:0);
	s(EmcSwizzleRank1Byte1, 6:4, scratch177, 5:3);
	s(EmcSwizzleRank1Byte1, 10:8, scratch177, 8:6);
	s(EmcSwizzleRank1Byte1, 14:12, scratch177, 11:9);
	s(EmcSwizzleRank1Byte1, 18:16, scratch177, 14:12);
	s(EmcSwizzleRank1Byte1, 22:20, scratch177, 17:15);

	s(EmcSwizzleRank1Byte2, 2:0, scratch178, 2:0);
	s(EmcSwizzleRank1Byte2, 6:4, scratch178, 5:3);
	s(EmcSwizzleRank1Byte2, 10:8, scratch178, 8:6);
	s(EmcSwizzleRank1Byte2, 14:12, scratch178, 11:9);
	s(EmcSwizzleRank1Byte2, 18:16, scratch178, 14:12);
	s(EmcSwizzleRank1Byte2, 22:20, scratch178, 17:15);

	s(EmcSwizzleRank1Byte3, 2:0, scratch179, 2:0);
	s(EmcSwizzleRank1Byte3, 6:4, scratch179, 5:3);
	s(EmcSwizzleRank1Byte3, 10:8, scratch179, 8:6);
	s(EmcSwizzleRank1Byte3, 14:12, scratch179, 11:9);
	s(EmcSwizzleRank1Byte3, 18:16, scratch179, 14:12);
	s(EmcSwizzleRank1Byte3, 22:20, scratch179, 17:15);

	s(ClearClk2Mc1, 0:0, scratch60, 30:30);
	s(EmcDbgWriteMux, 0:0, scratch61, 31:31);
	s(PmcIoDpd3ReqWait, 2:0, scratch68, 30:28);
	s(PmcIoDpd4ReqWait, 2:0, scratch70, 30:28);

	s32(EmcCmdMappingByte, secure_scratch8);
	s32(EmcPmacroBrickMapping0, secure_scratch9);
	s32(EmcPmacroBrickMapping1, secure_scratch10);
	s32(EmcPmacroBrickMapping2, secure_scratch11);

	s(EmcCmdMappingCmd0_0, 6:0, secure_scratch13, 6:0);
	s(EmcCmdMappingCmd0_0, 14:8, secure_scratch13, 13:7);
	s(EmcCmdMappingCmd0_0, 22:16, secure_scratch13, 20:14);
	s(EmcCmdMappingCmd0_0, 30:24, secure_scratch13, 27:21);

	s(EmcCmdMappingCmd0_1, 6:0, secure_scratch14, 6:0);
	s(EmcCmdMappingCmd0_1, 14:8, secure_scratch14, 13:7);
	s(EmcCmdMappingCmd0_1, 22:16, secure_scratch14, 20:14);
	s(EmcCmdMappingCmd0_1, 30:24, secure_scratch14, 27:21);

	s(EmcCmdMappingCmd0_2, 6:0, secure_scratch41, 6:0);
	s(EmcCmdMappingCmd0_2, 14:8, secure_scratch41, 13:7);
	s(EmcCmdMappingCmd0_2, 22:16, secure_scratch41, 20:14);
	s(EmcCmdMappingCmd0_2, 27:24, secure_scratch41, 24:21);

	s(EmcCmdMappingCmd1_0, 6:0, secure_scratch15, 6:0);
	s(EmcCmdMappingCmd1_0, 14:8, secure_scratch15, 13:7);
	s(EmcCmdMappingCmd1_0, 22:16, secure_scratch15, 20:14);
	s(EmcCmdMappingCmd1_0, 30:24, secure_scratch15, 27:21);

	s(EmcCmdMappingCmd1_1, 6:0, secure_scratch16, 6:0);
	s(EmcCmdMappingCmd1_1, 14:8, secure_scratch16, 13:7);
	s(EmcCmdMappingCmd1_1, 22:16, secure_scratch16, 20:14);
	s(EmcCmdMappingCmd1_1, 30:24, secure_scratch16, 27:21);

	s(EmcCmdMappingCmd1_2, 6:0, secure_scratch42, 6:0);
	s(EmcCmdMappingCmd1_2, 14:8, secure_scratch42, 13:7);
	s(EmcCmdMappingCmd1_2, 22:16, secure_scratch42, 20:14);
	s(EmcCmdMappingCmd1_2, 27:24, secure_scratch42, 24:21);

	s(EmcCmdMappingCmd2_0, 6:0, secure_scratch17, 6:0);
	s(EmcCmdMappingCmd2_0, 14:8, secure_scratch17, 13:7);
	s(EmcCmdMappingCmd2_0, 22:16, secure_scratch17, 20:14);
	s(EmcCmdMappingCmd2_0, 30:24, secure_scratch17, 27:21);

	s(EmcCmdMappingCmd2_1, 6:0, secure_scratch18, 6:0);
	s(EmcCmdMappingCmd2_1, 14:8, secure_scratch18, 13:7);
	s(EmcCmdMappingCmd2_1, 22:16, secure_scratch18, 20:14);
	s(EmcCmdMappingCmd2_1, 30:24, secure_scratch18, 27:21);

	s(EmcCmdMappingCmd2_2, 6:0, secure_scratch43, 6:0);
	s(EmcCmdMappingCmd2_2, 14:8, secure_scratch43, 13:7);
	s(EmcCmdMappingCmd2_2, 22:16, secure_scratch43, 20:14);
	s(EmcCmdMappingCmd2_2, 27:24, secure_scratch43, 24:21);

	s(EmcCmdMappingCmd3_0, 6:0, secure_scratch19, 6:0);
	s(EmcCmdMappingCmd3_0, 14:8, secure_scratch19, 13:7);
	s(EmcCmdMappingCmd3_0, 22:16, secure_scratch19, 20:14);
	s(EmcCmdMappingCmd3_0, 30:24, secure_scratch19, 27:21);

	s(EmcCmdMappingCmd3_1, 6:0, secure_scratch20, 6:0);
	s(EmcCmdMappingCmd3_1, 14:8, secure_scratch20, 13:7);
	s(EmcCmdMappingCmd3_1, 22:16, secure_scratch20, 20:14);
	s(EmcCmdMappingCmd3_1, 30:24, secure_scratch20, 27:21);

	s(EmcCmdMappingCmd3_2, 6:0, secure_scratch44, 6:0);
	s(EmcCmdMappingCmd3_2, 14:8, secure_scratch44, 13:7);
	s(EmcCmdMappingCmd3_2, 22:16, secure_scratch44, 20:14);
	s(EmcCmdMappingCmd3_2, 27:24, secure_scratch44, 24:21);

	s(PllMInputDivider, 7:0, scratch2, 7:0);
	s(PllMFeedbackDivider, 7:0, scratch2, 15:8);
	s(PllMPostDivider, 4:0, scratch2, 20:16);

	s(PllMSetupControl, 15:0, scratch35, 15:0);

	s(EmcPinGpio, 1:0, scratch8, 31:30);
	s(EmcPinGpioEn, 1:0, scratch9, 31:30);
	s(EmcPinProgramWait, 7:0, scratch89, 31:24);
}
