[![License: GPL v3](https://img.shields.io/badge/License-GPL%20v3-blue.svg)](https://www.gnu.org/licenses/gpl-3.0.html)
<a href="https://discord.gg/ez2HCgK"><img src="https://discordapp.com/api/guilds/488214231540301826/embed.png" alt="Discord Server" /></a>

# Windows

To easily configure the DragonInjector within Windows, you may use the offical [Dragon Injector Update Tool](https://github.com/dragoninjector-project/DragonInjector-UpdateTool/releases).

You may also configure the DragonInjector using any terminal client supporting serial COM ports. Instructions on how to do so may be found in the Linux section below.

# Linux

To configure the DragonInjector from within Linux, you will need a terminal client that supports serial COM ports.


[PuTTy](https://www.chiark.greenend.org.uk/~sgtatham/putty/latest.html) is the recommended client. To use PuTTy, carefully follow these instructions:


**Step 1**: 
Identify which COM port your DragonInjector has been assigned. In the below image (Windows is shown, but Linux should be similar) the DragonInjector has been assigned COM port 7.


![`Com Port 7`](https://media.discordapp.net/attachments/661387519136628836/698389229729742868/unknown.png?width=867&height=630)


**Step 2**: 
Launch PuTTy and enter the COM port, a connection speed of `115200` baud, and set connection type to `Serial`, as shown in the following image:


![`serial`](https://media.discordapp.net/attachments/661387519136628836/698389047374249984/unknown.png?width=621&height=629)


**Step 3**: 
Under the leftmost 'Category' menu, select `Terminal`.


**Step 4**: 
Set `Local Echo` and `Local Line Editing` to `Force on`.


![force on](https://media.discordapp.net/attachments/661387519136628836/698388712735637614/unknown.png?width=621&height=629)


**Step 5**: 
If you desire to save these parameters to ease future configuration, dnder the leftmost 'Category' menu, select `Session`.


**Step 6**: 
Enter a name for this configuration in the `Saved Sessions` field and press `Save`.


**Step 7**: 
Finally, press the `Open` button at the bottom of the window to begin the terminal session.


## Terminal Commands

You may enter `commands` to see a list of valid commands. The output should appear similar to this:


![commands](https://media.discordapp.net/attachments/661387519136628836/698389530784301178/unknown.png)


The following commands are available:

* `bdelay` - Changes how long the DragonInjector will look for a device in RCM mode before rebooting into update mode.
* `slots` - Sets the number of payload slots enabled when in multi-payload mode.
* `mdelay` - "ets the amount of time the capacitive button ( + ) must be held down to switch between single-payload and multi-payload modes. Mode switch is indicated with a long flash of the red LED.
* `cslot` - Active payload slot. 0 indicates the DragonInjector is in single-payload mode, and will launch the first payload it finds in /dragonboot/ on your MicroSD card. 1-9 indicates the DragonInjector is in multi-payload mode, and will launch the first payload it finds in /dragonboot/01/ through /dragonboot/09/ respectively. This setting cannot be higher than &quot;Maximum Multi-Mode Payload Slots&quot;.
* `rdelay` - Sets the advance interval for switching &quot;Currently Selected Payload Slot&quot; before injection. To use this feature, the DragonInjector must already be in multi-payload mode. Press and hold the capacitive button ( + ) while plugging in the DragonInjector. While the button is held, the selected payload slot will advance every time the configured delay time elapses, as indicated with the red LED. To inject the selected payload, cease holding the capacitive button.
* `dmode` - When set to enabled, the DragonInjector will always launch the first payload it finds in /dragonboot/01/ unless the capacitive button ( + ) is held down while plugging in the DragonInjector, in which case the first payload in /dragonboot/02/ will be launched. In this mode, &quot;Maximum Multi-Mode Payload Slots&quot;, &quot;Single/Multi-Mode Switch Delay&quot;, &quot;Currently Selected Payload Slot&quot; and &quot;Pre-RCM Selection Delay&quot; will have no effect.
* `reboot` - Reboots the Device
* `readall` - Printout all current settings
* `freset` - Factory Resets the Device
* `commands` - Shows a list of commands


When you are finished, you may simply close PuTTy and unplug your DragonInjector.
